### 设备树​

在***设备***视图(也称为设备树)中，您根据目标设备组织应用程序。在这个视图中，您可以看到 PLC 硬件和现场总线系统，配置硬件通信，并分配应用程序。

设备树的根节点是一个符号节点条目：。

你可以在该节点下面插入一个或多个控制装置的设备对象，也称为目标系统。每个设备对象表示一个特定的硬件组件，例如控制器、总线节点、总线耦合器、驱动、I/O模块或监视器。当您添加对象时，添加助手可以帮助您从本地设备存储库中提供所有可能的设备。

如果你已经连接到一个控制器网络，那么你可以扫描硬件可用的设备，并将它们保存到当前配置中的设备树上。

为了在设备树中创建设备对象（映射到控制硬件环境），应用具体的规则（见下文）。应用对象和设备对象的层次布局定义了其他对象的范围 ，例如库和GVL。

有可编程器件和可参数化的设备。设备类型定义了设备树中有可能的插入点以及可以在设备下面插入的对象的选择。可编程设备会自动在设备对象下获得一个额外的***PLC Logic***节点，这只是出于组织目的。在此节点下插入用于设备编程的对象（例如，应用程序和GVL或文本列表）。此概念的替代方法是，如果设备支持，使用设备应用程序。设备应用程序将控制器的所有应用程序的全局数据组合在一起，以便应用程序能够专门关注控制任务。

每个设备由设备描述定义，并且必须安装在本地系统中，以便插入到设备树中。设备描述文件定义配置的设备性能、可编程性，以及和其它设备连接的可能性。

注意：

***POU***视图包含可用于项目的对象。用于特定应用程序的编程对象必须在***设备***视图（设备树）的应用程序对象中插入。

请注意让活动应用程序运行在模拟设备上的选项，这是在开发系统中默认提供的。目前，该仿真选项可用于MetaFacture Control Win V3目标系统。在仿真模式下，您还可以测试没有硬件的应用程序的在线功能。单击***在线*** ➔ ***仿真***激活仿真模式 。

注意通过使用***在线配置模式***命令来建立连接到该设备的选项，而无需预先加载该应用程序。这对于I/O系统的初始调试非常有用，因为你可以在编写和下载实际应用程序之前，在PLC配置中使用它来引用和测试I/O。

设备树实例：

![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720702e258ad.png)

(1)可编程设备（有应用）  
(2)符号设备名称  
(3)设备名称（在设备描述中定义）  
(4)参数化的设备

  
设备树中的设备条目由符号、树中可编辑的符号设备名称和设备类型(设备描述中定义的设备名称)组成。

你可以在设备编辑器对话框中配置设备通信，参数和I/O映射。双击设备对象打开设备编辑器。

---

### 在设备树中用于排列和配置对象的规则和程序​

- **插入对象**：插入设备对象，单击***添加设***备或者在设备树中通过右键点击***插入设备***。对于其他对象来说，单击***添加对象***。MetaFacture在树中总是在当前选定位置时提供适当的对象。示例：PROFIBUS DP 从站的模块只能在相应的从对象下插入，应用程序只能插入到可编程设备下。设备对象的选择还取决于设备存储库中安装了哪些设备。
- 只能在根节点下直接**插入设备对象**。如果选择其他对象类型，如文本列表，然后MetaFacture把其自动地插入到***POU***视图(全局项目库)中。
- **插入应用:** 这里对具有***PLC Logic***节点的常规设备树结构和***设备应用程序***的使用进行了区分。以下内容适用于通常的结构(关于设备应用程序，请参阅本帮助的相关章节)。

你可以仅在***PLC Logic***节点（一个可编程的设备）下插入一个***Application***对象。所有应用程序必须为每个设备指定唯一的名称。每个应用程序下，可以插入多个用于编程的对象，例如POU、DUT、GVL、可视化。每个应用程序下，必须插入一个任务配置用来配置相应的程序调用（从应用程序特定的POU，或从***POU***视图中的POU实例）。如果多个应用程序位于设备的下方，则必须定义设备的设置用于I/O的处理。这包括MetaFacture用于与目标系统通信的应用程序的变量。这些设置是在设备编辑器的***PLC设置***选项卡上配置的。应用程序和范围的层次布局：您可以在另一个应用程序下面添加一个应用程序。我们将得到的结构称为父应用程序和子应用程序。在这种情况下，适用以下规定：子应用程序可以访问父应用程序中的对象，但不能反向访问。原因为子应用程序应始终是可移动或可交换的，而不影响父应用程序。  
**注意**：在父应用程序更改后，PLC在执行在线修改时删除一个子应用程序。

- **插入设备**MetaFacture在树上插入一个设备对象作为一个节点。如果在设备描述中定义节点，则将自动插入节点。子节点也可以代表一个可编程设备。在树中设备对象的顺序（从上到下）：对于每个级别，首先列出可编程设备（PLC Logic），然后按字母顺序列出其他类型。
- **更新设备**：已插入设备树中的设备可以由同一设备的另一个版本或另一种类型的设备替换***（更新设备）***。如果可能，可以使用设备下方的配置树。
- **移动和删除对象**：你可以应用标准命令***剪切、复制、粘贴、删除***对象, 或拖动一个对象到另一个位置。复制对象时，新对象将获得相同的名称并带有递增的数字。
- **当前硬件的网络扫描**：默认情况下，具有扫描功能的设备编辑器支持在设备树中创建PLC配置。扫描当前的硬件环境，检测到的模块显示在对话框中。 从那里，您可以将所需的设备直接保存到设备树。参阅***扫描设备***命令。

---

### 在线模式下的设备树​

在联机模式下，设备条目前的符号表示设备状态：

 ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/672072472a015.png)：PLC已连接，应用程序正运行，设备正运行，数据正在交换。在 PLC设置选项卡中的I/O更新停止 复选框中可被选择或清除。

![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720724e97850.png) ：PLC已连接，处于STOP模式；PLC设置选项卡中的停止时更新I/O 对话框被清除。

 ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720725232cd6.png)：设备没有交换数据；总线错误，无配置或仿真模式。

![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/672072564c486.png) ：设备在演示模式下运行30分钟。当此时间耗尽后，演示模式将终止，现场总线将结束数据交换。

 ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720725a647c7.png)：设备已配置，但尚未完全运行。没有交换数据。示例：在启动和操作模式前打开CANopen设备。

 ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720725e7993b.png)：冗余模式已激活。现场总线主机没有发送任何数据，因为另一个主机是处于活动状态。

 ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/672072629e02a.png)：在设备存储库中找不到设备描述。

 ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/67207267b8459.png)：设备本身正在运行，但子设备未运行或有诊断消息。由于设备树折叠，子设备不可见。

![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720726b151fb.png) ：灰色感叹号：设备本身正在运行，但子设备未运行或有诊断消息。诊断待定。错误原因不再存在。此符号可以与列表中的其他符号一起出现。

![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/6720726f116d7.png) ：红色感叹号：设备未运行或诊断待定。错误原因仍存在。此符号可以与列表中的其他符号一起出现。

所有连接设备的名称和应用程序都用绿色高亮显示。

![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/67207277171fa.png)

在仿真模式下运行的设备名称以斜体显示： ![](https://resource.helplook.net/docker_production/3648ne/article/zWVSY5j1/67207289915db.png)

附加的诊断信息位于相应设备编辑器的***状态***选项卡上。

###  

---

### 设备编辑器​

您可以在设备编辑器的选项卡上配置MetaFacture和目标设备之间的通信设置。双击设备树中的设备对象打开编辑器。编辑器包括通用选项卡和特定选项卡。它的标题包含设备名称。